## SA1136

<table>
<tr>
  <td>TypeName</td>
  <td>SA1136EnumValuesShouldBeOnSeparateLines</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1136</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

Multiple enum values are placed on the same line of code.

## Rule description

A violation of this rule occurs when two or more enum values are placed on the same line of code.

For example, the following code would produce a violation of this rule:

```csharp
public enum ExampleEnum
{
    FirstValue, SecondValue
}
```

The following code would not produce any violations:

```csharp
public enum ExampleEnum
{
    FirstValue,
    SecondValue
}
```

## How to fix violations

To fix a violation of this rule, place each enum value on its own line.

## How to suppress violations

```csharp
#pragma warning disable SA1136 // Enum values should be on separate lines
public enum ExampleEnum
{
    FirstValue, SecondValue
}
#pragma warning restore SA1136 // Enum values should be on separate lines
```
