﻿## SA1404

<table>
<tr>
  <td>TypeName</td>
  <td>SA1404CodeAnalysisSuppressionMustHaveJustification</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1404</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

## Cause

A Code Analysis SuppressMessage attribute does not include a justification.

## Rule description

A violation of this rule occurs when the code contains a Code Analysis SuppressMessage attribute, but a justification for the suppression has not been provided within the attribute. Whenever a Code Analysis rule is suppressed, a justification should be provided. This can increase the long-term maintainability of the code.

```csharp
[SuppressMessage("Microsoft.Performance", "CA1804:RemoveUnusedLocals", Justification = "Used during unit testing")]
public bool Enable()
{
}
```

## How to fix violations

To fix an instance of this violation, add a Justification tag and justification text to the SuppressMessage attribute describing the reason for the suppression.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1404:CodeAnalysisSuppressionMustHaveJustification", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1404 // CodeAnalysisSuppressionMustHaveJustification
#pragma warning restore SA1404 // CodeAnalysisSuppressionMustHaveJustification
```
