﻿## SA1514

<table>
<tr>
  <td>TypeName</td>
  <td>SA1514ElementDocumentationHeaderMustBePrecededByBlankLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1514</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

An element documentation header above a C# element is not preceded by a blank line.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines in other situations. This results in a consistent visual pattern across the code, which can improve recognition and readability of unfamiliar code.

A violation of this rule occurs when the element documentation header above an element is not preceded by a blank line. For example:

```csharp
public bool Visible
{
    get { return this.visible; }
}
/// <summary>
/// Gets a value indicating whether the control is enabled.
/// </summary>
public bool Enabled
{
    get { return this.enabled; }
}
```

The code above would generate an instance of this violation, since the documentation header is not preceded by a blank line.

An exception to this rule occurs when the documentation header is the first item within its scope. In this case, the header should not be preceded by a blank line. For example:

```csharp
public class Class1
{
    /// <summary>
    /// Gets a value indicating whether the control is enabled.
    /// </summary>
    public bool Enabled
    {
        get { return this.enabled; }
    }
}
```

In the code above, the header is the first item within its scope, and thus it should not be preceded by a blank line.

## How to fix violations

To fix a violation of this rule, add a blank line above the documentation header.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1514:ElementDocumentationHeaderMustBePrecededByBlankLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1514 // ElementDocumentationHeaderMustBePrecededByBlankLine
#pragma warning restore SA1514 // ElementDocumentationHeaderMustBePrecededByBlankLine
```
