﻿## SA1602

<table>
<tr>
  <td>TypeName</td>
  <td>SA1602EnumerationItemsMustBeDocumented</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1602</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

An item within a C# enumeration is missing an Xml documentation header.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when an item within an enumeration is missing a header. For example:

```csharp
/// <summary>
/// Types of animals.
/// </summary>
public enum Animals
{
    Dog,
    Cat,
    Horse
}
```

## How to fix violations

To fix a violation of this rule, add a documentation header for each item within the enum. For example:

```csharp
/// <summary>
/// Types of animals.
/// </summary>
public enum Animals
{
    /// <summary>
    /// Represents a dog.
    /// </summary>
    Dog,

    /// <summary>
    /// Represents a cat.
    /// </summary>
    Cat,

    /// <summary>
    /// Represents a horse.
    /// </summary>
    Horse
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1602:EnumerationItemsMustBeDocumented", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1602 // EnumerationItemsMustBeDocumented
#pragma warning restore SA1602 // EnumerationItemsMustBeDocumented
```
