﻿## SA1633

<table>
<tr>
  <td>TypeName</td>
  <td>SA1633FileMustHaveHeader</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1633</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

A C# code file is missing a standard file header.

## Rule description

A violation of this rule occurs when a C# source file is missing a file header.

The file header should begin at the start of the file, and it may only be preceded by whitespace.

The file header should be formatted as a block of comments containing either Xml or preconfigured text, as follows:

```csharp
//-----------------------------------------------------------------------
// <copyright file="NameOfFile.cs" company="CompanyName">
//     Company copyright tag.
// </copyright>
//-----------------------------------------------------------------------
```

or

```csharp
// Copyright (c) Tunnel Vision Laboratories, LLC. All Rights Reserved.
// Licensed under the MIT License. See LICENSE in the project root for license information.
```

The type of header to use depends on the setting of the `xmlHeader` property. See the [configuration](https://github.com/DotNetAnalyzers/StyleCopAnalyzers/blob/master/documentation/Configuration.md) section for details on how to set this up.

### Examples

For example, a file called Widget.cs from a fictional company called Sprocket Enterprises should contain a file header similar to the following:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="Sprocket Enterprises">
//     Copyright (c) Sprocket Enterprises. All rights reserved.
// </copyright>
//-----------------------------------------------------------------------
```

The dashed lines at the top and bottom of the header are not strictly necessary, so the header could be written as:

```csharp
// <copyright file="Widget.cs" company="Sprocket Enterprises">
//     Copyright (c) Sprocket Enterprises. All rights reserved.
// </copyright>
```

It is possible to add additional tags, although they will not be checked or enforced by StyleCop:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="Sprocket Enterprises">
//     Copyright (c) Sprocket Enterprises. All rights reserved.
// </copyright>
// <author>John Doe</author>
//-----------------------------------------------------------------------
```

A file that is completely auto-generated by a tool, and which should not be checked or enforced by StyleCop, can include an "auto-generated" header rather than the standard file header. This will cause StyleCop to ignore the file. This type of header should never be placed on top of a manually written code file.

```csharp
// <auto-generated />
namespace Sample.Something
{
    // The contents of this file are completely auto-generated by a tool.
}
```

## How to fix violations

To fix a violation of this rule, add a standard file header at the top of the file.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1633:FileMustHaveHeader", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1633 // FileMustHaveHeader
#pragma warning restore SA1633 // FileMustHaveHeader
```
