﻿## SA1634

<table>
<tr>
  <td>TypeName</td>
  <td>SA1634FileHeaderMustShowCopyright</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1634</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The file header at the top of a C# code file is missing a copyright tag.

## Rule description

A violation of this rule occurs when the file header at the top of a C# file is missing a copyright tag. For example:

```csharp
//-----------------------------------------------------------------------
//<Tag>A fileheader which does not contain a copyright tag</Tag>
//-----------------------------------------------------------------------
```

A file header should include a copyright tag, as follows:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="My Company">
//     Custom company copyright tag.
// </copyright>
//-----------------------------------------------------------------------
```

## How to fix violations

To fix a violation of this rule, add a standard copyright tag to the file header.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1634:FileHeaderMustShowCopyright", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1634 // FileHeaderMustShowCopyright
#pragma warning restore SA1634 // FileHeaderMustShowCopyright
```
