﻿## SA1639

<table>
<tr>
  <td>TypeName</td>
  <td>SA1639FileHeaderMustHaveSummary</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1639</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

:bulb: This rule is disabled by default.

## Cause

The file header at the top of a C# code file does not contain a filled-in summary tag.

## Rule description

A violation of this rule occurs when the file header at the top of a C# file does not contain a valid summary tag.

For example:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="My Company">
//     Custom company copyright tag.
// </copyright>
//-----------------------------------------------------------------------
```

If this rule is enabled, the file header should contain a summary tag. For example:

```csharp
//-----------------------------------------------------------------------
// <copyright file="Widget.cs" company="My Company">
//     Custom company copyright tag.
// </copyright>
// <summary>This is the Widget class.</summary>
//-----------------------------------------------------------------------
```

## How to fix violations

To fix a violation of this rule, add and fill-in a summary tag describing the contents of the file.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1639:FileHeaderMustHaveSummary", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1639 // FileHeaderMustHaveSummary
#pragma warning restore SA1639 // FileHeaderMustHaveSummary
```
