<h2>Why is this an issue?</h2>
<p>Shared naming conventions allow teams to collaborate efficiently.</p>
<p>This rule raises an issue when a method name does not match a provided regular expression.</p>
<p>For example, with the default provided regular expression <code>^[a-z][a-zA-Z0-9]*$</code>, the method:</p>

```java
public int DoSomething(){...} // Noncompliant
```
<p>should be renamed to</p>

```java
public int doSomething(){...}
```
<h3>Exceptions</h3>
<p>Overriding methods are excluded.</p>

```java
@Override
public int Do_Something(){...} // Compliant by exception
```