<h2>Why is this an issue?</h2>
<p>Methods with a long parameter list are difficult to use because maintainers must figure out the role of each parameter and keep track of their
position.</p>

```java
void setCoordinates(int x1, int y1, int z1, int x2, int y2, int z2) { // Noncompliant
    // ...
}
```
<p>The solution can be to:</p>
<ul>
  <li> Split the method into smaller ones </li>
</ul>

```java
// Each function does a part of what the original setCoordinates function was doing, so confusion risks are lower
void setOrigin(int x, int y, int z) {
   // ...
}

void setSize(int width, int height, int depth) {
   // ...
}
```
<ul>
  <li> Find a better data structure for the parameters that group data in a way that makes sense for the specific application domain </li>
</ul>

```java
class Point // In geometry, Point is a logical structure to group data
{
    public int x;
    public int y;
    public int z;
 };

void setCoordinates(Point p1, Point p2) {
    // ...
}
```
<p>This rule raises an issue when a method has more parameters than the provided threshold.</p>
<h3>Exceptions</h3>
<p>Methods annotated with :</p>
<ul>
  <li> Spring’s <code>@RequestMapping</code> (and related shortcut annotations, like <code>@GetRequest</code>) </li>
  <li> JAX-RS API annotations (like <code>@javax.ws.rs.GET</code>) </li>
  <li> Bean constructor injection with <code>@org.springframework.beans.factory.annotation.Autowired</code> </li>
  <li> CDI constructor injection with <code>@javax.inject.Inject</code> </li>
  <li> <code>@com.fasterxml.jackson.annotation.JsonCreator</code> </li>
  <li> Micronaut’s annotations (like <code>@io.micronaut.http.annotation.Get</code>) </li>
</ul>
<p>may have a lot of parameters, encapsulation being possible. Therefore the rule ignores such methods.</p>
<p>Also, if a class annotated as a Spring component (like <code>@org.springframework.stereotype.Component</code>) has a single constructor, that
constructor will be considered <code>@Autowired</code> and ignored by the rule.</p>