<p>Control structures are code statements that impact the program’s control flow (e.g., if statements, for loops, etc.)</p>
<h2>Why is this an issue?</h2>
<p>While not technically incorrect, the omission of curly braces can be misleading and may lead to the introduction of errors during maintenance.</p>
<p>In the following example, the two calls seem to be attached to the <code>if</code> statement, but only the first one is, and
<code>checkSomething</code> will always be executed:</p>

```java
if (condition)  // Noncompliant
  executeSomething();
  checkSomething();
```
<p>Adding curly braces improves the code readability and its robustness:</p>

```java
if (condition) {
  executeSomething();
  checkSomething();
}
```
<p>The rule raises an issue when a control structure has no curly braces.</p>
<h3>Exceptions</h3>
<p>The rule doesn’t raise an issue when the body of an <code>if</code> statement is a single <code>return</code>, <code>break</code>, or
<code>continue</code> and is on the same line.</p>
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/MzZGBQ">CERT, EXP52-J.</a> - Use braces for the body of an if, for, or while statement </li>
</ul>