<h2>Why is this an issue?</h2>
<p>According to the Java Code Conventions as defined by Oracle, the members of a class or interface declaration should appear in the following order
in the source files:</p>
<ul>
  <li> Class variables </li>
  <li> Instance variables </li>
  <li> Constructors </li>
  <li> Methods </li>
</ul>
<h3>Noncompliant code example</h3>

```java
public class Foo{
   private int field = 0;
   public boolean isTrue() {...}
   public Foo() {...}                         // Noncompliant, constructor defined after methods
   public static final int OPEN = 4;  //Noncompliant, variable defined after constructors and methods
}
```
<h3>Compliant solution</h3>

```java
public class Foo{
   public static final int OPEN = 4;
   private int field = 0;
   public Foo() {...}
   public boolean isTrue() {...}
}
```