<h2>Why is this an issue?</h2>
<p>Ternary expressions, while concise, can often lead to code that is difficult to read and understand, especially when they are nested or complex.
Prioritizing readability fosters maintainability and reduces the likelihood of bugs. Therefore, they should be removed in favor of more explicit
control structures, such as <code>if</code>/<code>else</code> statements, to improve the clarity and readability of the code.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
System.out.println(i>10?"yes":"no");  // Noncompliant
```
<h4>Compliant solution</h4>

```java
if (i > 10) {
  System.out.println("yes");
} else {
  System.out.println("no");
}
```