<h2>Why is this an issue?</h2>
<p>A value that is incremented or decremented and then not stored is at best wasted code and at worst a bug.</p>
<h3>Noncompliant code example</h3>

```java
public int pickNumber() {
  int i = 0;
  int j = 0;

  i = i++; // Noncompliant; i is still zero

  return j++; // Noncompliant; 0 returned
}
```
<h3>Compliant solution</h3>

```java
public int pickNumber() {
  int i = 0;
  int j = 0;

  i++;
  return ++j;
}
```