<h2>Why is this an issue?</h2>
<p>Some mathematical operations are unnecessary and should not be performed because their results are predictable.</p>
<p>For instance, <code>anyValue % 1</code> will always return 0, as any integer value can be divided by 1 without remainder.</p>
<p>Similarly, casting a non-floating-point to a floating-point value and then passing it to <code>Math.round</code>, <code>Math.ceil</code>, or
<code>Math.floor</code> is also unnecessary, as the result will always be the original value.</p>
<p>The following operations are unnecessary when given any constant value: <code>Math.abs</code>, <code>Math.ceil</code>, <code>Math.floor</code>,
<code>Math.rint</code>, <code>Math.round</code>. Instead, use the result of the operation directly.</p>
<p>The following operations are unnecessary with certain constants and can be replaced by the result of the operation directly:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>Operation</th>
      <th>Value</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p>acos</p></td>
      <td><p>0.0 or 1.0</p></td>
    </tr>
    <tr>
      <td><p>asin</p></td>
      <td><p>0.0 or 1.0</p></td>
    </tr>
    <tr>
      <td><p>atan</p></td>
      <td><p>0.0 or 1.0</p></td>
    </tr>
    <tr>
      <td><p>atan2</p></td>
      <td><p>0.0</p></td>
    </tr>
    <tr>
      <td><p>cbrt</p></td>
      <td><p>0.0 or 1.0</p></td>
    </tr>
    <tr>
      <td><p>cos</p></td>
      <td><p>0.0</p></td>
    </tr>
    <tr>
      <td><p>cosh</p></td>
      <td><p>0.0</p></td>
    </tr>
    <tr>
      <td><p>exp</p></td>
      <td><p>0.0 or 1.0</p></td>
    </tr>
    <tr>
      <td><p>expm1</p></td>
      <td><p>0.0</p></td>
    </tr>
    <tr>
      <td><p>log</p></td>
      <td><p>0.0 or 1.0</p></td>
    </tr>
    <tr>
      <td><p>log10</p></td>
      <td><p>0.0 or 1.0</p></td>
    </tr>
    <tr>
      <td><p>sin</p></td>
      <td><p>0.0</p></td>
    </tr>
    <tr>
      <td><p>sinh</p></td>
      <td><p>0.0</p></td>
    </tr>
    <tr>
      <td><p>sqrt</p></td>
      <td><p>0.0 or 1.0</p></td>
    </tr>
    <tr>
      <td><p>tan</p></td>
      <td><p>0.0</p></td>
    </tr>
    <tr>
      <td><p>tanh</p></td>
      <td><p>0.0</p></td>
    </tr>
    <tr>
      <td><p>toDegrees</p></td>
      <td><p>0.0 or 1.0</p></td>
    </tr>
    <tr>
      <td><p>toRadians</p></td>
      <td><p>0.0</p></td>
    </tr>
  </tbody>
</table>
<h2>How to fix it</h2>
<p>Ask yourself if the questionable operation represents the desired calculation or if a value used is erroneous. If the calculation is correct,
replace it with the result to avoid having to perform the unnecessary operation at runtime.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public void doMath(int a) {
  double res1 = Math.floor((double)a); // Noncompliant, the result will always be equal to '(double) a'
  double res2 = Math.ceil(4.2);        // Noncompliant, the result will always be 5.0
  double res3 = Math.atan(0.0);        // Noncompliant, the result will always be 0.0
}
```
<h4>Compliant solution</h4>

```java
public void doMath(int a) {
  double res1 = a;    // Compliant
  double res2 = 5.0;  // Compliant
  double res3 = 0.0;  // Compliant
}
```