<h2>Why is this an issue?</h2>
<p>The <code>readObject</code> method is implemented when a <code>Serializable</code> object requires special handling to be reconstructed from a
file. The object created by <code>readObject</code> is accessed only by the thread that called the method, thus using the <code>synchronized</code>
keyword in this context is unnecessary and causes confusion.</p>
<h3>Noncompliant code example</h3>

```java
private synchronized void readObject(java.io.ObjectInputStream in)
     throws IOException, ClassNotFoundException { // Noncompliant
  //...
}
```
<h3>Compliant solution</h3>

```java
private void readObject(java.io.ObjectInputStream in)
     throws IOException, ClassNotFoundException { // Compliant
  //...
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/io/Serializable.html">Oracle SDK 20 - Serializable</a> </li>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/io/ObjectInputStream.html">Oracle SDK 20 - ObjectInputStream</a>
  </li>
</ul>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> <a href="https://www.baeldung.com/java-serialization">Serialization in Java</a> </li>
</ul>