<h2>Why is this an issue?</h2>
<p>Under the reasoning that cleaner code is better code, the semicolon at the end of a try-with-resources construct should be omitted because it can
be omitted.</p>
<h3>Noncompliant code example</h3>

```java
try (ByteArrayInputStream b = new ByteArrayInputStream(new byte[10]);  // ignored; this one's required
      Reader r = new InputStreamReader(b);)   // Noncompliant
{
   //do stuff
}
```
<h3>Compliant solution</h3>

```java
try (ByteArrayInputStream b = new ByteArrayInputStream(new byte[10]);
      Reader r = new InputStreamReader(b))
{
   //do stuff
}
```