<h2>Why is this an issue?</h2>
<p>When two locks are held simultaneously, a <code>wait</code> call only releases one of them. The other will be held until some other thread requests
a lock on the awaited object. If no unrelated code tries to lock on that object, then all other threads will be locked out, resulting in a
deadlock.</p>
<h3>Noncompliant code example</h3>

```java
synchronized (this.mon1) {  // threadB can't enter this block to request this.mon2 lock & release threadA
	synchronized (this.mon2) {
		this.mon2.wait();  // Noncompliant; threadA is stuck here holding lock on this.mon1
	}
}
```