<h2>Why is this an issue?</h2>
<p>When using <code>Math.min()</code> and <code>Math.max()</code> together for bounds checking, it’s important to feed the right operands to each
method. <code>Math.min()</code> should be used with the <strong>upper</strong> end of the range being checked, and <code>Math.max()</code> should be
used with the <strong>lower</strong> end of the range. Get it backwards, and the result will always be the same end of the range.</p>
<h3>Noncompliant code example</h3>

```java
  private static final int UPPER = 20;
  private static final int LOWER = 0;

  public int doRangeCheck(int num) {    // Let's say num = 12
    int result = Math.min(LOWER, num);  // result = 0
    return Math.max(UPPER, result);     // Noncompliant; result is now 20: even though 12 was in the range
  }
```
<h3>Compliant solution</h3>
<p>Swapping method <code>min()</code> and <code>max()</code> invocations without changing parameters.</p>

```java
  private static final int UPPER = 20;
  private static final int LOWER = 0;

  public int doRangeCheck(int num) {    // Let's say num = 12
    int result = Math.max(LOWER, num);  // result = 12
    return Math.min(UPPER, result);     // Compliant; result is still 12
  }
```
<p>or swapping bounds <code>UPPER</code> and <code>LOWER</code> used as parameters without changing the invoked methods.</p>

```java
  private static final int UPPER = 20;
  private static final int LOWER = 0;

  public int doRangeCheck(int num) {    // Let's say num = 12
    int result = Math.min(UPPER, num);  // result = 12
    return Math.max(LOWER, result);     // Compliant; result is still 12
  }
```