<h2>Why is this an issue?</h2>
<p>In single-threaded environments, the use of <code>this</code> in constructors is normal, and expected. But in multi-threaded environments, it could
expose partially-constructed objects to other threads, and should be used with caution.</p>
<p>The classic example is a class with a <code>static</code> list of its instances. If the constructor stores <code>this</code> in the list, another
thread could access the object before it’s fully-formed. Even when the storage of <code>this</code> is the last instruction in the constructor,
there’s still a danger if the class is not <code>final</code>. In that case, the initialization of subclasses won’t be complete before
<code>this</code> is exposed.</p>
<p>This rule raises an issue when <code>this</code> is assigned to any globally-visible object in a constructor, and when it is passed to the method
of another object in a constructor</p>
<h3>Noncompliant code example</h3>

```java
public class Monument {

  public static final List<Monument> ALL_MONUMENTS = new ArrayList()<>;
  // ...

  public Monument(String location, ...) {
    ALL_MONUMENTS.add(this);  // Noncompliant; passed to a method of another object

    this.location = location;
    // ...
  }
}
```
<h3>Exceptions</h3>
<p>This rule ignores instances of assigning <code>this</code> directly to a <code>static</code> field of the same class because that case is covered
by <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S3010'>java:S3010</a> .</p>
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/iDdGBQ">CERT, TSM01-J.</a> - Do not let the this reference escape during object construction
  </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/vzdGBQ">CERT, TSM03-J.</a> - Do not publish partially initialized objects </li>
</ul>