<h2>Why is this an issue?</h2>
<p>The standard assertions library methods such as <code>org.junit.Assert.assertEquals</code>, and <code>org.junit.Assert.assertSame</code> expect the
first argument to be the expected value and the second argument to be the actual value. For AssertJ instead, the argument of
<code>org.assertj.core.api.Assertions.assertThat</code> is the actual value, and the subsequent calls contain the expected values.</p>
<h3>What is the potential impact?</h3>
<p>Having the expected value and the actual value in the wrong order will not alter the outcome of tests, (succeed/fail when it should) but the error
messages will contain misleading information.</p>
<p>This rule raises an issue when the actual argument to an assertions library method is a hard-coded value and the expected argument is not.</p>
<h2>How to fix it</h2>
<p>You should provide the assertion methods with a hard-coded value as the expected value, while the actual value of the assertion should derive from
the portion of code that you want to test.</p>
<p>Supported frameworks:</p>
<ul>
  <li> <a href="https://junit.org/junit4/">JUnit4</a> </li>
  <li> <a href="https://junit.org/junit5/docs/current/user-guide/">JUnit5</a> </li>
  <li> <a href="https://assertj.github.io/doc/">AssertJ</a> </li>
</ul>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
org.junit.Assert.assertEquals(runner.exitCode(), 0, "Unexpected exit code");  // Noncompliant; Yields error message like: Expected:<-1>. Actual:<0>.
org.assertj.core.api.Assertions.assertThat(0).isEqualTo(runner.exitCode()); // Noncompliant
```
<h4>Compliant solution</h4>

```java
org.junit.Assert.assertEquals(0, runner.exitCode(), "Unexpected exit code");
org.assertj.core.api.Assertions.assertThat(runner.exitCode()).isEqualTo(0);
```