<h2>Why is this an issue?</h2>
<p>Two methods having the same implementation are suspicious. It might be that something else was intended. Or the duplication is intentional, which
becomes a maintenance burden.</p>

```java
private final static String CODE = "bounteous";

public String calculateCode() {
  doTheThing();
  return CODE;
}

public String getName() {  // Noncompliant: duplicates calculateCode
  doTheThing();
  return CODE;
}
```
<p>If the identical logic is intentional, the code should be refactored to avoid duplication. For example, by having both methods call the same method
or by having one implementation invoke the other.</p>

```java
private final static String CODE = "bounteous";

public String getCode() {
  doTheThing();
  return CODE;
}

public String getName() { // The intent is clear
  return getCode();
}
```
<h3>Exceptions</h3>
<p>Methods that are not accessors (getters and setters), with fewer than 2 statements are ignored.</p>