<h2>Why is this an issue?</h2>
<p>Shared coding conventions allow teams to collaborate efficiently. This rule checks that all local, <code>final</code>, initialized, primitive
variables, have names that match a provided regular expression.</p>
<h3>Noncompliant code example</h3>
<p>With the default regular expression <code>^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$</code>:</p>

```java
public void doSomething() {
  final int local = 42;
  ...
}
```
<h3>Compliant solution</h3>

```java
public void doSomething() {
  final int LOCAL = 42;
  ...
}
```