<h2>Why is this an issue?</h2>
<p>Abstract classes should not have public constructors. Constructors of abstract classes can only be called in constructors of their subclasses. So
there is no point in making them public. The <code>protected</code> modifier should be enough.</p>
<h3>Noncompliant code example</h3>

```java
public abstract class AbstractClass1 {
    public AbstractClass1 () { // Noncompliant, has public modifier
        // do something here
    }
}
```
<h3>Compliant solution</h3>

```java
public abstract class AbstractClass2 {
    protected AbstractClass2 () {
        // do something here
    }
}
```