<h2>Why is this an issue?</h2>
<p>In Java 15 Text Blocks are official and can be used just like an ordinary String. However, when they are used to represent a big chunk of text,
they should not be used directly in complex expressions, as it decreases the readability. In this case, it is better to extract the text block into a
variable or a field.</p>
<p>This rule reports an issue when a text block longer than a number of lines given as a parameter is directly used within a lambda expression.</p>
<h3>Noncompliant code example</h3>

```java
listOfString.stream()
  .map(str -> !"""
    <project>
      <modelVersion>4.0.0</modelVersion>
      <parent>
        <groupId>com.mycompany.app</groupId>
        <artifactId>my-app</artifactId>
        <version>1</version>
      </parent>

      <groupId>com.mycompany.app</groupId>
      <artifactId>my-module</artifactId>
      <version>1</version>
    </project>
    """.equals(str));
```
<h3>Compliant solution</h3>

```java
String myTextBlock = """
    <project>
      <modelVersion>4.0.0</modelVersion>
      <parent>
        <groupId>com.mycompany.app</groupId>
        <artifactId>my-app</artifactId>
        <version>1</version>
      </parent>

      <groupId>com.mycompany.app</groupId>
      <artifactId>my-module</artifactId>
      <version>1</version>
    </project>
    """;

listOfString.stream()
  .map(str -> !myTextBlock.equals(str));
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://openjdk.java.net/jeps/378">JEP 378: Text Blocks</a> </li>
  <li> <a href="https://openjdk.org/projects/amber/guides/text-blocks-guide">Programmer’s Guide To Text Blocks</a>, by Jim Laskey and Stuart Marks
  </li>
</ul>