<h2>Why is this an issue?</h2>
<p>In Switch Expressions, an arrow label consisting of a block with a single <code>yield</code> can be simplified to directly return the value,
resulting in cleaner code.</p>
<p>Similarly, for Switch Statements and arrow labels, a <code>break</code> in a block is always redundant and should not be used. Furthermore, if the
resulting block contains only one statement, the curly braces of that block can also be omitted.</p>
<p>This rule reports an issue when a case of a Switch Expression contains a block with a single <code>yield</code> or when a Switch Statement contains
a block with a <code>break</code>.</p>
<h3>Noncompliant code example</h3>

```java
int i = switch (mode) {
  case "a" -> {        // Noncompliant: Remove the redundant block and yield.
    yield 1;
  }
  default -> {         // Noncompliant: Remove the redundant block and yield.
    yield 2;
  }
};

switch (mode) {
  case "a" -> {        // Noncompliant: Remove the redundant block and break.
    result = 1;
    break;
  }
  default -> {         // Noncompliant: Remove the redundant break.
    doSomethingElse();
    result = 2;
    break;
  }
}
```
<h3>Compliant solution</h3>

```java
int i = switch (mode) {
  case "a" -> 1;
  default -> 2;
};

switch (mode) {
  case "a" -> result = 1;
  default -> {
   doSomethingElse();
   result = 2;
 }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://openjdk.java.net/jeps/361">JEP 361: Switch Expressions</a> </li>
</ul>