<h2>Why is this an issue?</h2>
<p>Even if it is legal, mixing case and non-case labels in the body of a switch statement is very confusing and can even be the result of a typing
error.</p>
<h3>Noncompliant code example</h3>
<p>Case 1, the code is syntactically correct but the behavior is not the expected one</p>

```js
switch (day) {
  case MONDAY:
  case TUESDAY:
  WEDNESDAY:   // instead of "case WEDNESDAY"
    doSomething();
    break;
  ...
}
```
<p>Case 2, the code is correct and behaves as expected but is hardly readable</p>

```js
switch (day) {
  case MONDAY:
    break;
  case TUESDAY:
    foo:for(i = 0 ; i < X ; i++) {
         /* ... */
        break foo;  // this break statement doesn't relate to the nesting case TUESDAY
         /* ... */
    }
    break;
    /* ... */
}
```
<h3>Compliant solution</h3>
<p>Case 1</p>

```js
switch (day) {
  case MONDAY:
  case TUESDAY:
  case WEDNESDAY:
    doSomething();
    break;
  ...
}
```
<p>Case 2</p>

```js
switch (day) {
  case MONDAY:
    break;
  case TUESDAY:
    compute(args); // put the content of the labelled "for" statement in a dedicated method
    break;

    /* ... */
}
```