<h2>Why is this an issue?</h2>
<p>Integer literals starting with a zero are octal rather than decimal values. While using octal values is fully supported, most developers do not
have experience with them. They may not recognize octal values as such, mistaking them instead for decimal values.</p>
<p>Additionally, these literals will throw SyntaxError in strict mode. 0-prefixed octal literals have been deprecated since ECMAScript 5 and should
not be used in modern JavaScript code.</p>

```js
const myNumber = 010; // Noncompliant: Deprecated format
```
<p>Use decimal syntax when possible as it is more readable.</p>

```js
const myNumber = 8;
```
<p>If octal notation is required, use the standard syntax: a leading zero followed by a lowercase or uppercase Latin letter "O" (<code>0o</code> or
<code>0O</code>).</p>

```js
const myNumber = 0o10;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Numbers_and_dates#octal_numbers">Octal numbers</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Deprecated_octal">SyntaxError: "0"-prefixed
  octal literals are deprecated</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode">Strict mode</a> </li>
</ul>