<h2>Why is this an issue?</h2>
<p>A collection is a data structure that holds multiple values, such as an array or a map. If a collection is declared and populated, but its values
are never read anywhere in the code, it can be considered unused code. This can be due to some refactoring, copy-pasting, or typing errors.</p>
<p>Unused collections can waste memory usage and slow down the application’s performance. Additionally, they can make the code harder to read and
understand, especially for other developers working on the same codebase.</p>

```js
function getLength(a, b, c) {
  const strings = [];  // Noncompliant: Array is declared and populated but never read
  strings.push(a);
  strings.push(b);
  strings.push(c);

  return a.length + b.length + c.length;
}
```
<p>Remove unused collections so that the application can run faster and more smoothly. The code becomes cleaner and more efficient, making it easier
to read, understand, and maintain.</p>

```js
function getLength(a, b, c) {
  return a.length + b.length + c.length;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Indexed_collections">Indexed collections</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Keyed_collections">Keyed collections</a> </li>
</ul>