<h2>Why is this an issue?</h2>
<p>The spread operator is a more concise and more readable way to pass arguments to a function that takes a variable number of arguments (variadic
function). Prior to ES2015, the only way to call such functions with a variable number of arguments was to use the <code>.apply()</code> method.</p>

```js
foo.apply(undefined, args); // Noncompliant: use spread syntax instead of .apply()
foo.apply(null, args); // Noncompliant: use spread syntax instead of .apply()
obj.foo.apply(obj, args); // Noncompliant: use spread syntax instead of .apply()
```
<p>Using <code>.apply()</code> is no longer necessary in such cases - replace it with a spread operator applied to the array of arguments.</p>

```js
foo( ...args);
foo( ...args);
obj.foo( ...args);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Spread_syntax#spread_in_function_calls">spread syntax</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/apply"><code>apply()</code></a> </li>
</ul>