<h2>Why is this an issue?</h2>
<p>Calling a literal throws a TypeError, and is likely the result of an unintentional error in the code.</p>
<p>This rule raises an issue when an attempt is made to use a literal as a function.</p>

```js
true(); // Noncompliant, literal should not be used as function
```
<p>This rule also detects when a literal is used as a <em>tag</em> function.</p>

```js
true``; // Noncompliant, literal should not be used as tag function
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions">Functions</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals">Template literals</a> </li>
</ul>