<h2>Why is this an issue?</h2>
<p>The <code>when</code> statement should be used only to clearly define some new branches in the control flow. As soon as a case clause contains too
many statements this highly decreases the readability of the overall control flow statement. In such case, the content of the case clause should be
extracted into a dedicated function.</p>
<h3>Noncompliant code example</h3>
<p>With the threshold set at 5:</p>

```kotlin
when (myVariable) {
  0 -> {// Noncompliant: 6 lines till next case
    methodCall1("");
    methodCall2("");
    methodCall3("");
    methodCall4("");
    }
  1 -> {
    ...
  }
}
```
<h3>Compliant solution</h3>

```kotlin
when (myVariable) {
  0 -> doSomething()
  1 -> {
    ...
  }
}
...
fun doSomething() {
    methodCall1("");
    methodCall2("");
    methodCall3("");
    methodCall4("");
}
```