<h2>Why is this an issue?</h2>
<p>Enabling <code>runFinalizersOnExit</code> is unsafe as it might result in erratic behavior and deadlocks on application exit.</p>
<p>Indeed, finalizers might be force-called on live objects while other threads are concurrently manipulating them.</p>
<p>Instead, if you want to execute something when the virtual machine begins its shutdown sequence, you should attach a shutdown hook.</p>
<h3>Noncompliant code example</h3>

```kotlin
fun main() {
  System.runFinalizersOnExit(true)  // Noncompliant
}
```
<h3>Compliant solution</h3>

```kotlin
fun main() {
    Runtime.getRuntime().addShutdownHook(object : Thread() {
        override fun run() {
            doSomething()
        }
    })
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/4jZGBQ">CERT, MET12-J.</a> - Do not use finalizers. Although this resource talks about Java, the
  underlying information concerning the JVM are just as relevant for Kotlin. </li>
</ul>