<h2>Why is this an issue?</h2>
<p>Data classes have autogenerated implementations of <code>equals</code>, <code>hashcode</code>, <code>toString</code>, <code>copy</code> and
<code>componentN</code>. Although the former three methods can still be overridden, there is no use to do so if no special logic is required. The
latter two methods cannot be overridden and cause a compile-time error if attempted.</p>
<p>This rule reports an issue on simple <code>equals</code> and <code>hashCode</code> implementations with no additional logic beyond the default
behaviour.</p>
<h3>Noncompliant code example</h3>

```kotlin
data class Person(val name: String, val age: Int) {
    override fun equals(other: Any?): Boolean { // Noncompliant
        return other is Person && other.name == name && other.age == age
    }

    override fun hashCode() = Objects.hash(name, age) // Noncompliant
}
```
<h3>Compliant solution</h3>

```kotlin
data class Person(String name, int age) // Compliant

data class Person(val name: String, val age: Int) {
    override fun equals(other: Any?): Boolean { // Compliant
        return other is Person && other.name.lowercase() == name.lowercase() && other.age == age
    }

    override fun hashCode() = Objects.hash(name.lowercase(), age) // Compliant
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://kotlinlang.org/docs/data-classes.html">Data classes (Kotlin documentation)</a> </li>
</ul>