<h2>Why is this an issue?</h2>
<p>The actions performed by a task are often too complex or specific, and the task name cannot describe the task’s action sufficiently well. Moreover,
build scripts usually consist of many tasks - whether explicitly defined or implicitly by the applied plugins - so a structure is required to help the
user navigate through existing tasks.</p>
<p>Therefore, tasks should define a <code>description</code> and <code>group</code> to provide documentation and categorization for the user.</p>
<h3>What is the potential impact?</h3>
<h4>Improve task discoverability</h4>
<p>Users can find tasks easier and understand their purpose if they contain a description and are grouped into categories.</p>
<h2>How to fix it</h2>
<p>Assign the <code>description</code> and <code>group</code> properties in your task configuration.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```kotlin
tasks.register<DocsGenerate>("generateHtmlDocs") { // Noncompliant, does neither define "description" and "group"
    title.set("Project docs")
    outputDir.set(layout.buildDirectory.dir("docs"))
}
```
<h4>Compliant solution</h4>

```kotlin
tasks.register<DocsGenerate>("generateHtmlDocs") { // Compliant, defines "description" and "group"
    description = "Generates the HTML documentation for this project."
    group = JavaBasePlugin.DOCUMENTATION_GROUP
    title.set("Project docs")
    outputDir.set(layout.buildDirectory.dir("docs"))
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.gradle.org/current/userguide/authoring_maintainable_build_scripts.html#sec:improving_task_discoverability">Gradle
  Documentation - Improve task discoverability</a> </li>
</ul>