<h2>Why is this an issue?</h2>
<p>According to the Single Responsibility Principle, introduced by Robert C. Martin in his book "Principles of Object Oriented Design", a class should
have only one responsibility:</p>
<blockquote>
  <p>If a class has more than one responsibility, then the responsibilities become coupled.</p>
  <p>Changes to one responsibility may impair or inhibit the class' ability to meet the others.</p>
  <p>This kind of coupling leads to fragile designs that break in unexpected ways when changed.</p>
</blockquote>
<p>Classes which rely on many other classes tend to aggregate too many responsibilities and should be split into several smaller ones.</p>
<p>Nested classes dependencies are not counted as dependencies of the outer class.</p>
<h3>Noncompliant code example</h3>

```php
  class Foo {            // Noncompliant - Foo depends on too many classes: T1, T2, T3, T4, T5, T6 and T7
    /**
     * @var T1
     */
    public $a1;          // Foo is coupled to T1
    /**
     * @var T2
     */
    protected $a2;       // Foo is coupled to T2
    /**
     * @var T3
     */
    private $a3;         // Foo is coupled to T3

    /**
     * @param T5
     * @param T6
     *
     * @return T4
     */
    public function compute(T5 $a, $b) { // Foo is coupled to T4, T5 and T6
      $result = new T7();     // Foo is coupled to T7
      return $result;
  }
}
```