<h2>Why is this an issue?</h2>
<p>In PHP, keywords and constants are case-insensitive, meaning they can be written in either lower case or upper case without affecting their
functionality. This allows for more flexibility and ease of use when writing code.</p>
<p>However, it is generally recommended to follow a consistent casing convention for readability and maintainability purposes. Relevant constants are
<code>true</code>, <code>false</code> and <code>null</code>.</p>
<p>Note that if the Drupal framework is detected, this rule will enforce Drupal standards instead. Relevant constants are <code>TRUE</code>,
<code>FALSE</code> and <code>NULL</code>.</p>
<h3>Noncompliant code example</h3>

```php
<?php ECHO 'Hello World'; ?>
```

```php
<?php
// In a Drupal context
const CACHE_ENABLED = true;
?>
```
<h3>Compliant solution</h3>

```php
<?php echo 'Hello World'; ?>
```

```php
<?php
// In a Drupal context
const CACHE_ENABLED = TRUE;
?>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.php.net/manual/en/reserved.constants.php">PHP Manual - Predefined Constants</a> </li>
  <li> <a href="https://www.drupal.org/docs/develop/standards/php/php-coding-standards#s-constants">Drupal - Naming Conventions - Constants</a> </li>
</ul>