<h2>Why is this an issue?</h2>
<p>Deprecated language features are those that have been retained temporarily for backward compatibility, but which will eventually be removed from
the language. In effect, deprecation announces a grace period to allow the smooth transition from the old features to the new ones. In that period, no
use of the deprecated features should be added to the code, and all existing uses should be gradually removed.</p>
<p>The following functions were deprecated in PHP 5:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>Deprecated</th>
      <th>Use Instead</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p><code>call_user_method()</code></p></td>
      <td><p><code>call_user_func()</code></p></td>
    </tr>
    <tr>
      <td><p><code>call_user_method_array()</code></p></td>
      <td><p><code>call_user_func_array()</code></p></td>
    </tr>
    <tr>
      <td><p><code>define_syslog_variables()</code></p></td>
      <td></td>
    </tr>
    <tr>
      <td><p><code>dl()</code></p></td>
      <td></td>
    </tr>
    <tr>
      <td><p><code>ereg()</code></p></td>
      <td><p><code>preg_match()</code></p></td>
    </tr>
    <tr>
      <td><p><code>ereg_replace()</code></p></td>
      <td><p><code>preg_replace()</code> (note that this is deprecated in PHP 5.5)</p></td>
    </tr>
    <tr>
      <td><p><code>eregi()</code></p></td>
      <td><p><code>preg_match()</code> with 'i' modifier</p></td>
    </tr>
    <tr>
      <td><p><code>eregi_replace()</code></p></td>
      <td><p><code>preg_replace()</code> with 'i' modifier</p></td>
    </tr>
    <tr>
      <td><p><code>set_magic_quotes_runtime()</code> and its alias, <code>magic_quotes_runtime()</code></p></td>
      <td></td>
    </tr>
    <tr>
      <td><p><code>session_register()</code></p></td>
      <td><p><code>$_SESSION</code> superglobal</p></td>
    </tr>
    <tr>
      <td><p><code>session_unregister()</code></p></td>
      <td><p><code>$_SESSION</code> superglobal</p></td>
    </tr>
    <tr>
      <td><p><code>session_is_registered()</code></p></td>
      <td><p><code>$_SESSION</code> superglobal</p></td>
    </tr>
    <tr>
      <td><p><code>set_socket_blocking()</code></p></td>
      <td><p><code>stream_set_blocking()</code></p></td>
    </tr>
    <tr>
      <td><p><code>split()</code></p></td>
      <td><p><code>preg_split()</code></p></td>
    </tr>
    <tr>
      <td><p><code>spliti()</code></p></td>
      <td><p><code>preg_split()</code> with 'i' modifier</p></td>
    </tr>
    <tr>
      <td><p><code>sql_regcase()</code></p></td>
      <td></td>
    </tr>
    <tr>
      <td><p><code>mysql_db_query()</code></p></td>
      <td><p><code>mysql_select_db()</code> and <code>mysql_query()</code></p></td>
    </tr>
    <tr>
      <td><p><code>mysql_escape_string()</code></p></td>
      <td><p><code>mysql_real_escape_string()</code></p></td>
    </tr>
    <tr>
      <td><p>Passing locale category names as strings</p></td>
      <td><p>Use the LC_* family of constants</p></td>
    </tr>
  </tbody>
</table>
<p>The following functions were deprecated in PHP 7:</p>
<table>
  <colgroup>
    <col style="width: 50%;">
    <col style="width: 50%;">
  </colgroup>
  <thead>
    <tr>
      <th>Deprecated</th>
      <th>Use Instead</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p><code>__autoload()</code></p></td>
      <td><p><code>spl_autoload_register()</code></p></td>
    </tr>
    <tr>
      <td><p><code>create_function()</code></p></td>
      <td><p>anonymous function</p></td>
    </tr>
    <tr>
      <td><p><code>parse_str()</code> without second argument</p></td>
      <td><p><code>parse_str()</code> with second argument</p></td>
    </tr>
    <tr>
      <td><p><code>gmp_random()</code></p></td>
      <td><p><code>gmp_random_bits()</code> or <code>gmp_random_range()</code></p></td>
    </tr>
    <tr>
      <td><p><code>each()</code></p></td>
      <td><p><code>foreach</code></p></td>
    </tr>
    <tr>
      <td><p><code>assert()</code> with string argument</p></td>
      <td></td>
    </tr>
    <tr>
      <td><p>Defining case-insensitive constants by calling <code>define()</code> with <code>true</code> as third parameter</p></td>
      <td><p><code>define("myconst", $value)</code> or <code>define("myconst", $value, false)</code></p></td>
    </tr>
    <tr>
      <td><p><code>FILTER_FLAG_SCHEME_REQUIRED</code> and <code>FILTER_FLAG_HOST_REQUIRED</code> flags</p></td>
      <td><p><code>FILTER_VALIDATE_URL</code> flag</p></td>
    </tr>
    <tr>
      <td><p><code>fgetss()</code> function, <code>"string.strip_tags"</code> stream filter name, <code>SplFileObject::fgetss()</code> method and
      <code>gzgetss()</code> function</p></td>
      <td></td>
    </tr>
    <tr>
      <td><p><code>mbregex_encoding()</code>, <code>mbereg()</code>, <code>mberegi()</code>, <code>mbereg_replace()</code>,
      <code>mberegi_replace()</code>, <code>mbsplit()</code>, <code>mbereg_match()</code>, <code>mbereg_search()</code>,
      <code>mbereg_search_pos()</code>, <code>mbereg_search_regs()</code>, <code>mbereg_search_init()</code>, <code>mbereg_search_getregs()</code>,
      <code>mbereg_search_getpos()</code>, <code>mbereg_search_setpos()</code></p></td>
      <td><p>Use the</p> <p> corresponding <code>mb_ereg_*()</code> variants instead</p></td>
    </tr>
    <tr>
      <td><p>string search functions with integer needle (<code>stristr</code>, <code>strrchr</code>, <code>strstr</code>, <code>strripos</code>,
      <code>stripos</code>, <code>strrpos</code>, <code>strpos</code>, <code>strchr</code>)</p></td>
      <td><p>use a string needle instead</p></td>
    </tr>
    <tr>
      <td><p><code>image2wbmp()</code></p></td>
      <td><p><code>imagewbmp()</code></p></td>
    </tr>
    <tr>
      <td><p><code>Normalizer::NONE</code></p></td>
      <td></td>
    </tr>
    <tr>
      <td><p>Defining an <code>assert()</code> function inside a namespace</p></td>
      <td><p>use the standard <code>assert()</code> function</p></td>
    </tr>
  </tbody>
</table>
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.php.net/rfc/deprecations_php_7_3">PHP RFC: Deprecations for PHP 7.3</a> </li>
  <li> <a href="https://wiki.php.net/rfc/case_insensitive_constant_deprecation">PHP RFC: Deprecate and Remove Case-Insensitive Constants</a> </li>
</ul>