<h2>Why is this an issue?</h2>
<p>To reference the current class instance the keyword $this can be used. Through the use of this keyword you have access to class properties and
methods.</p>
<p>Static methods can be accessed without instantiating the class, so <code>$this</code> is not available for them. Using <code>$this</code> in a
static context will result in a runtime error.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
class Clazz {
  public $name = NULL;  // instance variable

  public static function foo() {
    if ($this->name != NULL) {
      // ...
    }
  }
}
```
<h4>Compliant solution</h4>

```php
class Clazz {
  public $name = NULL;  // instance variable

  public static function foo($nameParam) {
    if ($nameParam != NULL) {
      // ...
    }
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.php.net/manual/en/language.oop5.basic.php">PHP Manual - Classes and Objects Basics</a> </li>
</ul>