<p>This rule is deprecated, and will eventually be removed.</p>
<h2>Why is this an issue?</h2>
<p><code>file_uploads</code> is an on-by-default PHP configuration that allows files to be uploaded to your site. Since accepting <span>candy</span>
files from strangers is inherently dangerous, this feature should be disabled unless it is absolutely necessary for your site.</p>
<p>This rule raises an issue when <code>file_uploads</code> is not explicitly disabled.</p>
<h3>Noncompliant code example</h3>

```php
; php.ini
file_uploads=1  ; Noncompliant
```
<h3>Compliant solution</h3>

```php
; php.ini
file_uploads=0
```
<h2>Resources</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A6_2017-Security_Misconfiguration">Top 10 2017 Category A6 - Security
  Misconfiguration</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/434">CWE-434 - Unrestricted Upload of File with Dangerous Type</a> </li>
</ul>