<h2>Why is this an issue?</h2>
<p>When verifying that code raises an exception, a good practice is to avoid having multiple method calls inside the tested code, to be explicit about
what is exactly tested.</p>
<p>When two of the methods can raise the same exception, not respecting this good practice is a bug, since it is not possible to know what is really
tested.</p>
<h3>Noncompliant code example</h3>

```php
public function testSomething()
{
  try {
    g(y(1)); // Noncompliant
    $this->fail('RuntimeException is not thrown');
  } catch (RuntimeException $e) {}
}
```
<h3>Compliant solution</h3>

```php
public function testSomething()
{
  $y = y(1);
  try {
    g($y);
    $this->fail('RuntimeException is not thrown by g()');
  } catch (RuntimeException $e) {}
}
```