<h2>Why is this an issue?</h2>
<p>WordPress relies a lot on the configuration located in a file named <code>wp-config.php</code>. This file contains mostly <code>define</code>
statements and each of them creates a constant for a given WordPress option. However, no warning appears if an option is misspelled: the statement
simply defines a constant which is never used.</p>
<p>This rule raises an issue when a file named <code>wp-config.php</code> defines a constant whose name is slightly different from a known WordPress
option.</p>
<h2>How to fix it in WordPress</h2>
<p>Fix the typing mistake or rename your custom defined constant to be more unique.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
define( 'DISALLOW_FILE_MOD', true ); // Noncompliant
define( 'Disallow_File_Mods', true ); // Noncompliant
```
<h4>Compliant solution</h4>

```php
define( 'DISALLOW_FILE_MODS', true );
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://developer.wordpress.org/apis/wp-config-php/">WordPress Developer Resources: wp-config.php</a> </li>
</ul>