<h2>Why is this an issue?</h2>
<p>A boolean literal can be represented in two different ways: <code>true</code> or <code>false</code>. They can be combined with logical operators
(<code>!, &amp;&amp;, ||, ==, !=</code>) to produce logical expressions that represent truth values. However, comparing a boolean literal to a
variable or expression that evaluates to a boolean value is unnecessary and can make the code harder to read and understand. The more complex a
boolean expression is, the harder it will be for developers to understand its meaning and expected behavior, and it will favour the introduction of
new bugs.</p>
<h2>How to fix it</h2>
<p>Remove redundant boolean literals from expressions to improve readability and make the code more maintainable.</p>

```ts
if (someValue == true) { /* ... */ } // Noncompliant: Redundant comparison
if (someBooleanValue != true) { /* ... */ } // Noncompliant: Redundant comparison
if (booleanMethod() || false) { /* ... */ }  // Noncompliant: Redundant OR
doSomething(!false); // Noncompliant: Redundant negation
```
<p>Remove redundant boolean literals to improve readability.</p>

```ts
if (someValue) { /* ... */ }
if (!someBooleanValue) { /* ... */ }
if (booleanMethod()) { /* ... */ }
doSomething(true);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Equality_comparisons_and_sameness">Equality comparisons and
  sameness</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Boolean">Boolean</a> </li>
</ul>