<h2>Why is this an issue?</h2>
<p>A <code>for</code> loop is a type of loop construct that allows a block of code to be executed repeatedly for a fixed number of times. The
<code>for</code> loop is typically used when the number of iterations is known in advance, and consists of three parts:</p>
<ul>
  <li> The initialization statement is executed once at the beginning of the loop, and is used to initialize the loop counter or any other variables
  that may be used in the loop. </li>
  <li> The loop condition is evaluated at the beginning of each iteration, and if it is <code>true</code>, the code inside the loop is executed. </li>
  <li> The update statement is executed at the end of each iteration, and is used to update the loop counter or any other variables that may be used
  in the loop. </li>
</ul>

```ts
for (initialization; condition; update) { /*...*/ }
```
<p>All three statements are optional. However, when the initialization and update statements are not used, it can be unclear to the reader what the
loop counter is and how it is being updated. This can make the code harder to understand and maintain.</p>

```ts
for (;condition;) { /*...*/ } // Noncompliant: Only the condition is specified
```
<p>When only the condition expression is defined in a <code>for</code> loop, a <code>while</code> loop should be used instead to increase readability.
A <code>while</code> loop consists of a single loop condition and allows a block of code to be executed repeatedly as long as the specified condition
is true.</p>

```ts
while (condition) { /*...*/ }
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for"><code>for</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/while"><code>while</code></a> </li>
</ul>