<h2>Why is this an issue?</h2>
<p>Bitwise operations are operations that manipulate individual bits in binary representations of numbers. These operations work at the binary level,
treating numbers as sequences of 32 bits (in 32-bit environments) or 64 bits (in 64-bit environments). However, they should not be used in a boolean
context because they have different behaviors compared to logical operators when applied to boolean values:</p>
<ul>
  <li> When applied to boolean values, bitwise AND (<code>&amp;</code>) and OR (<code>|</code>) perform bitwise operations on the binary
  representation of the numbers. They treat the operands as 32-bit signed integers and manipulate their individual bits. </li>
  <li> Logical AND (<code>&amp;&amp;</code>) and OR (<code>||</code>) are specifically designed for boolean operations. They return a boolean value
  based on the truthiness or falsiness of the operands.<code>&amp;&amp;</code> returns <code>true</code> if both operands are truthy; otherwise, it
  returns <code>false</code>. <code>||</code> operator returns <code>true</code> if at least one of the operands is truthy; otherwise, it returns
  <code>false</code>. </li>
</ul>
<p>Bitwise operators <code>&amp;</code> and <code>|</code> can be easily mistaken for logical operators <code>&amp;&amp;</code> and <code>||</code>,
especially for those who are not familiar with the distinction between them or their specific use cases.</p>
<p>This rule raises an issue when <code>&amp;</code> or <code>|</code> is used in a boolean context.</p>

```ts
if (a & b) { /* ... */ } // Noncompliant: The operator & is used in a boolean context
```
<p>You should use the logical variant of the bitwise operator, that is, <code>&amp;&amp;</code> instead of <code>&amp;</code> and <code>||</code>
instead of <code>|</code>.</p>

```ts
if (a && b) { /* ... */ }
```
<h3>Exceptions</h3>
<p>When a file contains other bitwise operations, (<code>^</code>, <code>&lt;&lt;</code>, <code>&gt;&gt;&gt;</code>, <code>&gt;&gt;</code>,
<code>~</code>, <code>&amp;=</code>, <code>^=</code>, <code>|=</code>, <code>&lt;&lt;=</code>, <code>&gt;&gt;=</code>, <code>&gt;&gt;&gt;=</code>, and
<code>&amp;</code> or <code>|</code> used with a numeric literal as the right operand) all issues in the file are ignored, because it is evidence that
bitwise operations were truly intended.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Bitwise_AND">Bitwise AND
  (<code>&amp;</code>)</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Bitwise_OR">Bitwise OR (<code>|</code>)</a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Logical_AND">Logical AND
  (<code>&amp;&amp;</code>)</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Logical_OR">Logical OR
  (<code>||</code>)</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Truthy">Truthy</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Falsy">Falsy</a> </li>
</ul>