<h2>Why is this an issue?</h2>
<p>Nested functions refer to the practice of defining a function within another function. These inner functions have access to the variables and
parameters of the outer function, creating a closure.</p>
<p>While nesting functions is a common practice in JavaScript, deeply nested functions can make the code harder to read and understand, especially if
the functions are long or if there are many levels of nesting.</p>
<p>This can make it difficult for other developers or even yourself to understand and maintain the code.</p>
<h3>Noncompliant code example</h3>
<p>With the default threshold of 4 levels:</p>

```ts
function f() {
  function f_inner() {
    function f_inner_inner() {
      function f_inner_inner_inner() {
        function f_inner_inner_inner_inner() { // Noncompliant
        }
      }
    }
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Functions#nested_functions_and_closures">Nested functions
  and closures</a> </li>
</ul>