<h2>Why is this an issue?</h2>
<p>Assigning <code>this</code> to a local variable is a way to reference parent context inside inner functions. In TypeScript when using arrow
functions this happens automatically.</p>
<p>This rule raises an issue when <code>this</code> is assigned to a local variable.</p>
<h3>Noncompliant code example</h3>

```ts
function Foo() {
  let that = this;  // Noncompliant
  that.val = 0;

  setInterval(function() {
    that.val++;
  }, 1000);
}
```
<h3>Compliant solution</h3>

```ts
function Foo() {
  this.val = 0;

  setInterval(() => {
    this.val++;
  }, 1000);
}
```
<h3>Exceptions</h3>
<p>This rule ignores <code>this</code> used for destructuring.</p>

```ts
const { foo, bar } = this;
```
<p>The rule also ignores alias references of <code>this</code> in generators.</p>

```ts
const self = this;
return function* () {
  let result = self.next();
  while (!result.done) {
    yield result.value;
    result = self.next();
  }
};
```