<h2>Why is this an issue?</h2>
<p>TypeScript provides enums to allow developers to define a set of named constants under a common type. These enum constants can be assigned values,
but it is not mandatory to assign all of them. Those that are not assigned get default values in increasing order starting from zero. As a result,
assigning only a subset of enum members can be misleading. For numeric enums in particular, that would create a gap in the numerical order, which
could lead to unfortunate bugs. In addition, adding more members or moving around existing ones might change their values.</p>
<p>This rule raises an issue whenever an enum assigns a subset of its members, unless the first member only is assigned a numerical literal.</p>

```ts
enum Key {
    Up = 1,
    Down,
    Left,
    Right
}
```
<h2>How to fix it</h2>
<p>Either assign a value to all enum members or none of them, or assign a number literal to the first enum member only.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
enum Digit {
   Zero,
   One,
   ...
   Nine = 9
}
```
<h4>Compliant solution</h4>

```ts
enum Digit {
    Zero,
    One,
    ...
    Nine
}
```
<h4>Noncompliant code example</h4>

```ts
enum RGB {
   Red,
   Green,
   Blue = 0b000000000000000011111111
}
```
<h4>Compliant solution</h4>

```ts
enum RGB {
   Red   = 0b111111110000000000000000,
   Green = 0b000000001111111100000000,
   Blue  = 0b000000000000000011111111
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/enums.html">Enums</a> </li>
</ul>