<h2>Why is this an issue?</h2>
<p>In React, a <code>PureComponent</code> is a class component that is optimized for performance by implementing a shallow comparison of props and
state. It is a subclass of the regular React <code>Component</code> class and provides a default implementation of the
<code>shouldComponentUpdate</code> method.</p>
<p>The <code>shouldComponentUpdate</code> method is responsible for determining whether a component should re-render or not. By default, it returns
true and triggers a re-render every time the component receives new props or state. However, <code>PureComponent</code> overrides this method and
performs a shallow comparison of the current and next props and state. If there are no changes, it prevents unnecessary re-renders by returning
false.</p>
<p>Therefore, defining a <code>shouldComponentUpdate</code> method while extending <code>PureComponent</code> is redundant and should be avoided. By
not defining <code>shouldComponentUpdate</code>, you allow <code>React.PureComponent</code> to handle the optimization for you.</p>

```ts
class MyComponent extends React.PureComponent { // Noncompliant
  shouldComponentUpdate() {
    // does something
  }

  render() {
    return <div>Hello!</div>
  }
}
```
<p>You should either remove the redundant method <code>shouldComponentUpdate</code> or turn your component into a regular one by extending
<code>Component</code>.</p>

```ts
class MyComponent extends React.Component {
  shouldComponentUpdate() {
    // does something
  }

  render() {
    return <div>Hello!</div>
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/reference/react/Component#shouldcomponentupdate">shouldComponentUpdate</a> </li>
  <li> React Documentation - <a href="https://react.dev/reference/react/PureComponent">PureComponent</a> </li>
</ul>