<p>HTML documents should have a valid IETF’s BCP 47 <code>lang</code> attribute.</p>
<h2>Why is this an issue?</h2>
<p>Screen readers require a specified language to function correctly. Without it, they default to the user’s set language, causing issues for
multilingual users. Specifying a valid language ensures correct pronunciation and a less confusing experience.</p>
<h2>How to fix it</h2>
<p>Add a <code>lang</code> attribute with a valid IETF BCP 47 value.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
<html></html>
```
<h4>Compliant solution</h4>

```ts
<html lang="en"></html>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> W3C, <a href="https://www.w3.org/International/articles/language-tags/">Language tags in HTML and XML</a> </li>
</ul>