# Empty Enum Arguments

Arguments can be omitted when matching enums with associated values if they are not used.

* **Identifier:** empty_enum_arguments
* **Supports autocorrection:** Yes
* **Kind:** style
* **Analyzer rule:** No
* **Minimum Swift compiler version:** 3.0.0
* **Default configuration:** warning

## Non Triggering Examples

```swift
switch foo {
case .bar: break
}
```

```swift
switch foo {
case .bar(let x): break
}
```

```swift
switch foo {
case let .bar(x): break
}
```

```swift
switch (foo, bar) {
case (_, _): break
}
```

```swift
switch foo {
case "bar".uppercased(): break
}
```

```swift
switch (foo, bar) {
case (_, _) where !something: break
}
```

```swift
switch foo {
case (let f as () -> String)?: break
}
```

```swift
switch foo {
default: break
}
```

```swift
if case .bar = foo {
}
```

```swift
guard case .bar = foo else {
}
```

```swift
if foo == .bar() {}
```

```swift
guard foo == .bar() else { return }
```

## Triggering Examples

```swift
switch foo {
case .bar↓(_): break
}
```

```swift
switch foo {
case .bar↓(): break
}
```

```swift
switch foo {
case .bar↓(_), .bar2↓(_): break
}
```

```swift
switch foo {
case .bar↓() where method() > 2: break
}
```

```swift
func example(foo: Foo) {
    switch foo {
    case case .bar↓(_):
        break
    }
}
```

```swift
if case .bar↓(_) = foo {
}
```

```swift
guard case .bar↓(_) = foo else {
}
```

```swift
if case .bar↓() = foo {
}
```

```swift
guard case .bar↓() = foo else {
}
```